/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.statetransition;

import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.config.ClassData;
import com.ibm.hwmca.fw.service.config.ClassUtils;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorCreationException;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.service.statetransition.Engine;
import com.ibm.hwmca.fw.service.statetransition.Result;
import com.ibm.hwmca.fw.service.statetransition.Sensor;
import com.ibm.hwmca.fw.service.statetransition.SensorCreationException;
import com.ibm.hwmca.fw.service.statetransition.SensorException;
import com.ibm.hwmca.fw.service.statetransition.StateTransitionSupportException;
import com.ibm.hwmca.fw.service.statetransition.UndefinedVariableException;
import com.ibm.hwmca.fw.service.statetransition.UnresolvableValueException;
import com.ibm.hwmca.fw.service.statetransition.UnresolvableValueSensorException;
import com.ibm.hwmca.fw.service.statetransition.UpdateNotAllowedException;
import com.ibm.hwmca.fw.service.statetransition.ValueException;
import com.ibm.hwmca.fw.service.statetransition.ValueTypeMismatchException;
import com.ibm.hwmca.fw.service.statetransition.Variable;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class StateTransitionSupport
extends CommonXMLParser {
    private static String XML_FILE = "data/service/rules/xfw/repair/IONonSPCN_ExchangeAndVerifyRules.xml";
    private static final String TRACE_MASKT = "XRVFSTST";
    private static final String TRACE_MASKF = "XRVFSTSF";
    private static final String TRACE_MASKD = "XRVFSTSD";
    private static String PROPERTY_VALUE_CHANGED = "PropertyValueChanged";
    private static final String TAG_RULES = "rules";
    private static final String TAG_RULE = "rule";
    private static final String TAG_RULECONFIGURATION = "rules-configuration";
    private static final String TAG_VARIABLES = "variables";
    private static final String TAG_DEFINE_VARIABLE = "define-variable";
    private static final String TAG_VALUE_SETS = "value-sets";
    private static final String TAG_VALUE_SET = "value-set";
    private static final String TAG_DEFINE_VALUE_SET = "define-value-set";
    private static final String TAG_IFTRUE = "iftrue";
    private static final String TAG_AND = "and";
    private static final String TAG_OR = "or";
    private static final String TAG_NOT = "not";
    private static final String TAG_EQUAL = "equal";
    private static final String TAG_LESSTHAN = "lessthan";
    private static final String TAG_GREATERTHAN = "greaterthan";
    private static final String TAG_REFERENCE = "reference";
    private static final String TAG_VAR = "var";
    private static final String TAG_MIN = "min";
    private static final String TAG_MAX = "max";
    private static final String TAG_TYPE = "type";
    private static final String TAG_INIT = "init";
    private static final String TAG_VALUES = "values";
    private static final String TAG_VALUE = "value";
    private static final String TAG_DESC = "desc";
    private static final String TAG_INPUT_MAP = "input-map";
    private static final String TAG_CLASS = "class";
    private static final String TAG_OVERRIDE_FILE = "override-file";
    private static final String TAG_CONSTANTS_CLASS = "constants-class";
    private static final String TAG_SENSORS = "sensors";
    private static final String TAG_DEFINE_SENSOR = "define-sensor";
    private static final String TAG_SENSOR = "sensor";
    private static final String TAG_EFFECTORS = "effectors";
    private static final String TAG_DEFINE_EFFECTOR = "define-effector";
    private static final String TAG_ASSIGN = "assign";
    private static final String TAG_IF = "if";
    private static final String TAG_THEN = "then";
    private static final String ATTRIB_EFFECTOR = "effector";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_VAR = "var";
    private static final String ATTRIB_SENSOR = "sensor";
    private static final String ATTRIB_INTERNAL = "internal";
    private static final String ATTRIB_GLOBAL = "global";
    private static final String ATTRIB_BOOLEAN = "boolean";
    private static final String ATTRIB_INTEGER = "integer";
    private static final String ATTRIB_STRING = "string";
    private static final String ATTRIB_TYPE = "type";
    private static final String ATTRIB_PARENT = "parent";
    private static final int EQUALITY = 0;
    private static final int LESS_THAN = 1;
    private static final int GREATER_THAN = 2;
    private ContextImpl context = null;
    private Class constantsClass = null;
    private RuleImpl ruleBeingBuilt = null;
    public static final String BOOLEAN = "boolean";
    public static final String INTEGER = "integer";
    public static final String STRING = "string";

    public static void main(String[] args) {
        try {
            String filename = args.length == 0 ? XML_FILE : args[0];
            File file = new File(System.getProperty("CONSOLE_PATH") + "/" + filename);
            Context context = StateTransitionSupport.parseRules(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private StateTransitionSupport() throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public static Engine createEngine() {
        return new EngineImpl();
    }

    public static Context parseRules(File file) throws StateTransitionSupportException {
        return StateTransitionSupport.parseRules(file, null);
    }

    public static Context parseRules(File file, Context parentContext) throws StateTransitionSupportException {
        Trace.trace(TRACE_MASKT, "-> parseRules for single file: " + file);
        try {
            StateTransitionSupport sts = new StateTransitionSupport();
            ContextImpl context = new ContextImpl();
            context = sts.parseRules_internal(file, context);
            Trace.trace(TRACE_MASKT, "<- parseRules");
            context.setParentContext(parentContext);
            return context;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! parseRules exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            if (e instanceof StateTransitionSupportException) {
                throw (StateTransitionSupportException)e;
            }
            throw new StateTransitionSupportException(e);
        }
    }

    private ContextImpl parseRules_internal(File file, ContextImpl _context) throws StateTransitionSupportException {
        try {
            this.parse(new InputSource(new FileInputStream(file)));
            Document doc = this.getDocument();
            if (!doc.getDoctype().getName().equals(TAG_RULECONFIGURATION)) {
                throw new StateTransitionSupportException("unsupported DTD; file[" + file.getName() + "], DTD[" + doc.getDoctype().getName() + "]");
            }
            NodeList nodeList = doc.getElementsByTagName(TAG_OVERRIDE_FILE);
            this.context = nodeList != null && nodeList.getLength() > 0 ? this.parseRules_internal(this.parseOverride(nodeList.item(0)), _context) : _context;
            nodeList = doc.getElementsByTagName(TAG_CONSTANTS_CLASS);
            if (nodeList != null && nodeList.getLength() > 0) {
                this.parseConstantsClass(nodeList.item(0));
            }
            if ((nodeList = doc.getElementsByTagName(TAG_VALUE_SETS)) != null && nodeList.getLength() > 0) {
                this.parseValueSets(nodeList.item(0));
            }
            if ((nodeList = doc.getElementsByTagName(TAG_VARIABLES)) != null && nodeList.getLength() > 0) {
                this.parseVariables(nodeList.item(0));
            }
            if ((nodeList = doc.getElementsByTagName(TAG_SENSORS)) != null && nodeList.getLength() > 0) {
                this.parseSensors(nodeList.item(0));
            }
            if ((nodeList = doc.getElementsByTagName(TAG_EFFECTORS)) != null && nodeList.getLength() > 0) {
                this.parseEffectors(nodeList.item(0));
            }
            if ((nodeList = doc.getElementsByTagName(TAG_RULES)) != null && nodeList.getLength() > 0) {
                this.parseRules(nodeList.item(0));
            }
            return this.context;
        }
        catch (Throwable thrown) {
            if (thrown instanceof StateTransitionSupportException) {
                throw (StateTransitionSupportException)thrown;
            }
            throw new StateTransitionSupportException(thrown);
        }
    }

    private File parseOverride(Node node) throws StateTransitionSupportException {
        Trace.trace(TRACE_MASKT, "-> parseOverride");
        File fileToOverride = null;
        try {
            String fileToOverrideName = CommonXMLParser.gatherTextContents(node);
            Trace.trace(TRACE_MASKF, "parseOverride: overriding file: " + fileToOverrideName);
            fileToOverride = new File(System.getProperty("CONSOLE_PATH") + "/" + fileToOverrideName);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! parseOverride: exception caught resolving override file: " + e);
            throw new StateTransitionSupportException("exception caught resolving override file : " + e);
        }
        if (fileToOverride == null) {
            Trace.trace(TRACE_MASKT, "<-! parseOverride: unable to resolve override file");
            throw new StateTransitionSupportException("unable to resolve override file");
        }
        Trace.trace(TRACE_MASKT, "<- parseOverride: override file object: " + fileToOverride);
        return fileToOverride;
    }

    private void parseConstantsClass(Node node) throws StateTransitionSupportException {
        Trace.trace(TRACE_MASKT, "-> parseConstantsClass");
        try {
            String constantsClassName = CommonXMLParser.gatherTextContents(node);
            Trace.trace(TRACE_MASKF, "parseConstantsClass, classname: " + constantsClassName);
            this.constantsClass = Class.forName(constantsClassName);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! parseConstantsClass: exception caught:  " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new StateTransitionSupportException("exception caught resolving constant classname Class object");
        }
        Trace.trace(TRACE_MASKT, "<- parseConstantsClass");
    }

    private void parseSensors(Node nodeToParse) throws ValueException, MalformedXMLException {
        NodeList nodes = nodeToParse.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node node = nodes.item(aii);
            if (node.getNodeType() == 1) {
                SensorData s = this.parseSensor(node);
                this.context.removeSensorData(s.getName());
                this.context.addSensorData(s.getName(), s);
            }
            ++aii;
        }
    }

    private SensorData parseSensor(Node nodeToParse) throws ValueException, MalformedXMLException {
        Node name = nodeToParse.getAttributes().getNamedItem(ATTRIB_NAME);
        String nameval = name.getNodeValue();
        Node type = nodeToParse.getAttributes().getNamedItem("type");
        String typeval = type.getNodeValue();
        SensorData s = new SensorData(nameval);
        s.setType(typeval);
        NodeList nodes = nodeToParse.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node node = nodes.item(aii);
            if (node.getNodeType() == 1) {
                String tag = node.getNodeName().toLowerCase();
                if (tag.equals(TAG_DESC)) {
                    s.setDescription(CommonXMLParser.gatherTextContents(node));
                } else if (tag.equals(TAG_CLASS)) {
                    s.setClassName(CommonXMLParser.gatherTextContents(node));
                } else if (tag.equals(TAG_INPUT_MAP)) {
                    s.setConfigData(ClassData.parseInputMap(node));
                } else if (tag.equals(TAG_VALUES)) {
                    this.parseAndSetupAllowableValues(node, s, nameval, typeval);
                }
            }
            ++aii;
        }
        return s;
    }

    private void parseEffectors(Node nodeToParse) throws ValueException, MalformedXMLException {
        NodeList nodes = nodeToParse.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node node = nodes.item(aii);
            if (node.getNodeType() == 1) {
                EffectorData e = this.parseEffector(node);
                this.context.removeEffectorData(e.getName());
                this.context.addEffectorData(e.getName(), e);
            }
            ++aii;
        }
    }

    private EffectorData parseEffector(Node nodeToParse) throws MalformedXMLException {
        Node name = nodeToParse.getAttributes().getNamedItem(ATTRIB_NAME);
        EffectorData e = new EffectorData(name.getNodeValue());
        NodeList nodes = nodeToParse.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node node = nodes.item(aii);
            if (node.getNodeType() == 1) {
                String tag = node.getNodeName().toLowerCase();
                if (tag.equals(TAG_DESC)) {
                    e.setDescription(CommonXMLParser.gatherTextContents(node));
                } else if (tag.equals(TAG_CLASS)) {
                    e.setClassName(CommonXMLParser.gatherTextContents(node));
                } else if (tag.equals(TAG_INPUT_MAP)) {
                    e.setConfigData(ClassData.parseInputMap(node));
                }
            }
            ++aii;
        }
        return e;
    }

    private void parseValueSets(Node nodeToParse) throws ValueException, MalformedXMLException {
        NodeList nodes = nodeToParse.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node node = nodes.item(aii);
            if (node.getNodeType() == 1) {
                ValueSet vs = this.parseValueSet(node);
                this.context.addValueSet(vs.getName(), vs);
            }
            ++aii;
        }
    }

    private ValueSet parseValueSet(Node nodeToParse) throws ValueException, MalformedXMLException {
        NodeList nodes = nodeToParse.getChildNodes();
        String name = nodeToParse.getAttributes().getNamedItem(ATTRIB_NAME).getNodeValue();
        ValueSet vs = this.context.getValueSet(name);
        if (vs == null) {
            vs = new ValueSet();
            vs.setName(name);
        }
        vs.resetValues();
        Node typeNode = nodeToParse.getAttributes().getNamedItem("type");
        String type = typeNode.getNodeValue().toLowerCase();
        vs.setType(type);
        Trace.trace(TRACE_MASKD, "parseValueSet: name: " + name + ", type: " + type);
        List valueList = null;
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node node = nodes.item(aii);
            if (node.getNodeType() == 1) {
                String tag = node.getNodeName().toLowerCase();
                Trace.trace(TRACE_MASKD, "parseValueSet: parsing tag: " + tag);
                if (tag.equals(TAG_VALUES)) {
                    valueList = this.parseValuesTag(node, type);
                } else if (tag.equals(TAG_DESC)) {
                    vs.setDesc(CommonXMLParser.gatherTextContents(node));
                }
            }
            ++aii;
        }
        vs.setValues(valueList);
        return vs;
    }

    private List parseValuesTag(Node nodeToParse, String type) throws ValueException, MalformedXMLException {
        LinkedList<String> list = new LinkedList<String>();
        NodeList valueNodes = nodeToParse.getChildNodes();
        int aii = 0;
        while (aii < valueNodes.getLength()) {
            Node vnode = valueNodes.item(aii);
            if (vnode.getNodeType() == 1) {
                String vtag = vnode.getNodeName().toLowerCase();
                if (vtag.equals(TAG_VALUE)) {
                    String value = CommonXMLParser.gatherTextContents(vnode);
                    Trace.trace(TRACE_MASKD, "parseValuesTag: parsing value tag: " + vtag + ", value:" + value + " (type " + type + ")");
                    this.resolveValue(value);
                    this.validateValue(value, type);
                    list.add(value);
                } else if (vtag.equals(TAG_VALUE_SET)) {
                    String valueSetName = CommonXMLParser.gatherTextContents(vnode);
                    Trace.trace(TRACE_MASKD, "parseValuesTag: <value-set>" + valueSetName + "</value-set>");
                    ValueSet vs = this.context.getValueSet(valueSetName);
                    if (vs == null) {
                        Trace.trace(TRACE_MASKT, "<-! parseValuesTag: undefined value-set:" + valueSetName);
                        throw new ValueException("undefined value-set:" + valueSetName);
                    }
                    List valueSetValues = vs.getValues();
                    if (valueSetValues != null) {
                        if (!vs.getType().equals(type)) {
                            Trace.trace(TRACE_MASKT, "<-! parseValuesTag: type mismatch: <value-set>" + vs.getName() + "</value-set> which is type \"" + vs.getType() + "\" is specified under a <values> tag of type \"" + type + "\"");
                            throw new ValueException("type mismatch: <value-set>" + vs.getName() + "</value-set> which is type \"" + vs.getType() + "\" is specified under a <values> tag of type \"" + type + "\"");
                        }
                        Iterator it = valueSetValues.iterator();
                        while (it.hasNext()) {
                            String value = (String)it.next();
                            Trace.trace(TRACE_MASKD, "parseValuesTag: parsed value-set value:" + value);
                            this.validateValue(value, type);
                            list.add(value);
                        }
                    }
                }
            }
            ++aii;
        }
        return list;
    }

    private String resolveValue(String value) throws ValueException {
        Class toTest = this.constantsClass;
        boolean done = toTest == null;
        String classesTried = null;
        while (!done) {
            Trace.trace(TRACE_MASKT, "resolveValue: looking for Field(" + value + ") in the constants class(" + toTest + ")");
            try {
                Field constantFileFieldName = toTest.getDeclaredField(value);
                Object o = constantFileFieldName.get(null);
                if (!(o instanceof String)) {
                    Trace.trace(TRACE_MASKT, "<-! resolveValue: Field(" + value + ") in the constants class(" + toTest + ") is NOT a String object (" + o.getClass() + ")");
                    throw new ValueException("Field(" + value + ") in the constants class(" + toTest + ") is NOT a String object (" + o.getClass() + ")");
                }
                value = (String)o;
                done = true;
            }
            catch (Exception e) {
                classesTried = classesTried == null ? toTest.getName() : classesTried + "|" + toTest.getName();
                Class superClass = toTest.getSuperclass();
                if (superClass == null) {
                    Trace.trace(TRACE_MASKT, "<-! resolveValue: exception caught trying to resolve Field(" + value + ") in the constant class hierarchy(" + classesTried + "). Exception(" + e + ")");
                    throw new ValueException("exception caught trying to resolve Field(" + value + ") in the constant class hierarchy(" + classesTried + "). Exception(" + e + ")");
                }
                Trace.trace(TRACE_MASKT, "resolveValue: resolve Field(" + value + ") not found in(" + toTest + "); will try superclass(" + superClass + ")");
                toTest = superClass;
            }
        }
        return value;
    }

    private void parseVariables(Node nodeToParse) throws ValueException, MalformedXMLException {
        NodeList nodes = nodeToParse.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node node = nodes.item(aii);
            if (node.getNodeType() == 1) {
                VariableImpl v = this.parseVariable(node);
                this.context.removeVariable(v.getName());
                this.context.addVariable(v.getName(), v);
            }
            ++aii;
        }
    }

    private VariableImpl parseVariable(Node nodeToParse) throws ValueException, MalformedXMLException {
        VariableImpl variable = null;
        String type = nodeToParse.getAttributes().getNamedItem("type").getNodeValue().toLowerCase();
        if (type.equals("integer")) {
            variable = this.parseInteger(nodeToParse);
        } else if (type.equals("string")) {
            variable = this.parseString(nodeToParse);
        } else if (type.equals("boolean")) {
            variable = this.parseBoolean(nodeToParse);
        }
        return variable;
    }

    private VariableImpl parseInteger(Node nodeToParse) throws ValueException, MalformedXMLException {
        IntegerVariable v = new IntegerVariable();
        this.parseVariable_common(nodeToParse, v, "integer");
        NodeList nodes = nodeToParse.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node node = nodes.item(aii);
            if (node.getNodeType() == 1) {
                String tag = node.getNodeName().toLowerCase();
                if (tag.equals(TAG_MIN)) {
                    v.setMin(CommonXMLParser.gatherTextContents(node));
                } else if (tag.equals(TAG_MAX)) {
                    v.setMax(CommonXMLParser.gatherTextContents(node));
                }
            }
            ++aii;
        }
        return v;
    }

    private VariableImpl parseString(Node nodeToParse) throws ValueException, MalformedXMLException {
        StringVariable v = new StringVariable();
        this.parseVariable_common(nodeToParse, v, "string");
        return v;
    }

    private VariableImpl parseBoolean(Node nodeToParse) throws ValueException, MalformedXMLException {
        BooleanVariable v = new BooleanVariable();
        this.parseVariable_common(nodeToParse, v, "boolean");
        return v;
    }

    private void parseVariable_common(Node nodeToParse, VariableImpl v, String type) throws ValueException, MalformedXMLException {
        NodeList nodes = nodeToParse.getChildNodes();
        Node name = nodeToParse.getAttributes().getNamedItem(ATTRIB_NAME);
        Node global = nodeToParse.getAttributes().getNamedItem(ATTRIB_GLOBAL);
        if (global != null) {
            v.setGlobal(Boolean.valueOf(global.getNodeValue().toLowerCase()));
        } else {
            v.setGlobal(false);
        }
        String nameval = name.getNodeValue();
        v.setName(nameval);
        Trace.trace(TRACE_MASKD, "parseVariable_common: variable: " + nameval + ", global: " + v.isGlobal());
        String initValue = null;
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node node = nodes.item(aii);
            if (node.getNodeType() == 1) {
                String tag = node.getNodeName().toLowerCase();
                Trace.trace(TRACE_MASKD, "parseVariable_common: parsing tag: " + tag);
                if (tag.equals(TAG_INIT)) {
                    initValue = CommonXMLParser.gatherTextContents(node);
                    Trace.trace(TRACE_MASKD, "parseVariable_common: init value found: " + initValue);
                } else if (tag.equals(TAG_VALUES)) {
                    this.parseAndSetupAllowableValues(node, v, nameval, type);
                } else if (tag.equals(TAG_DESC)) {
                    v.setDescription(CommonXMLParser.gatherTextContents(node));
                }
            }
            ++aii;
        }
        if (initValue != null) {
            v.validate(initValue);
            v.setValue(initValue);
            v.commit();
        }
    }

    private void parseAndSetupAllowableValues(Node nodeToParse, ValueSetListener v, String sourceObjectName, String sourceObjectType) throws ValueException, MalformedXMLException {
        LinkedList list = new LinkedList();
        NodeList valueNodes = nodeToParse.getChildNodes();
        int aii = 0;
        while (aii < valueNodes.getLength()) {
            Node vnode = valueNodes.item(aii);
            if (vnode.getNodeType() == 1) {
                ValueSet vs;
                String vtag = vnode.getNodeName().toLowerCase();
                if (vtag.equals(TAG_VALUE)) {
                    ArrayList<String> dummyValueSetVals;
                    String value = CommonXMLParser.gatherTextContents(vnode);
                    this.resolveValue(value);
                    this.validateValue(value, sourceObjectType);
                    vs = this.context.getValueSet("__" + sourceObjectName + "|" + sourceObjectType + "__");
                    if (vs == null) {
                        vs = new ValueSet();
                        vs.setName("__" + sourceObjectName + "|" + sourceObjectType + "__");
                        vs.setType(sourceObjectType);
                        vs.setDesc("internal value set for variable " + sourceObjectName);
                        this.context.addValueSet(vs.getName(), vs);
                        v.addValueSet(vs);
                    }
                    if ((dummyValueSetVals = vs.getValues()) == null) {
                        dummyValueSetVals = new ArrayList<String>(valueNodes.getLength());
                    }
                    dummyValueSetVals.add(value);
                    vs.setValues(dummyValueSetVals);
                } else if (vtag.equals(TAG_VALUE_SET)) {
                    String valueSetName = CommonXMLParser.gatherTextContents(vnode);
                    Trace.trace(TRACE_MASKD, "parseAndSetupAllowableValues: <value-set>" + valueSetName + "</value-set>");
                    vs = this.context.getValueSet(valueSetName);
                    if (vs == null) {
                        Trace.trace(TRACE_MASKT, "<-! parseAndSetupAllowableValues: undefined value-set:" + valueSetName);
                        throw new ValueException("undefined value-set:" + valueSetName);
                    }
                    if (vs.getType().equals(sourceObjectType)) {
                        v.addValueSet(vs);
                    } else {
                        Trace.trace(TRACE_MASKT, "<-! parseAndSetupAllowableValues: type mismatch between object def: " + sourceObjectName + " and value-set:" + vs.getName() + "(" + sourceObjectType + " vs " + vs.getType() + ")");
                        throw new ValueException("type mismatch between object def:" + sourceObjectName + " and value-set:" + vs.getName() + "(" + sourceObjectType + " vs " + vs.getType() + ")");
                    }
                }
            }
            ++aii;
        }
    }

    private boolean validateValue(String value, String type) throws ValueException {
        boolean valid = false;
        if (type.equals("boolean")) {
            valid = StateTransitionSupport.validBoolean(value);
        } else if (type.equals("integer")) {
            valid = StateTransitionSupport.validInteger(value);
        } else if (type.equals("string")) {
            valid = StateTransitionSupport.validString(value);
        } else {
            Trace.trace(TRACE_MASKT, "<-! validateValue: unknown value type:" + type);
            throw new ValueException("validateValue: unknown value type:" + type);
        }
        if (!valid) {
            Trace.trace(TRACE_MASKT, "<-! validateValue: invalid value specified:" + value);
            throw new ValueException("validateValue: invalid value specified:" + value);
        }
        return valid;
    }

    private void parseRules(Node nodeToParse) throws MalformedXMLException {
        NodeList nodes = nodeToParse.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node node = nodes.item(aii);
            if (node.getNodeType() == 1 && node.getNodeName().toLowerCase().equals(TAG_RULE)) {
                RuleImpl rule = this.parseRule(node);
                this.context.removeRule(rule.getName());
                this.context.addRule(rule.getName(), rule);
            }
            ++aii;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuleImpl parseRule(Node nodeToParse) throws MalformedXMLException {
        try {
            Node name = nodeToParse.getAttributes().getNamedItem(ATTRIB_NAME);
            this.ruleBeingBuilt = new RuleImpl(name.getNodeValue());
            Node internal = nodeToParse.getAttributes().getNamedItem(ATTRIB_INTERNAL);
            if (internal != null) {
                this.ruleBeingBuilt.setInternal(Boolean.valueOf(internal.getNodeValue().toLowerCase()));
            }
            Trace.trace(TRACE_MASKD, "parseRule:" + this.ruleBeingBuilt.getName() + ", isInternal=" + this.ruleBeingBuilt.isInternal());
            NodeList nodes = nodeToParse.getChildNodes();
            int aii = 0;
            while (aii < nodes.getLength()) {
                Node node = nodes.item(aii);
                String tag = node.getNodeName().toLowerCase();
                if (node.getNodeType() == 1) {
                    if (tag.equals(TAG_IF)) {
                        this.parseIf(node);
                    } else if (tag.equals(TAG_THEN)) {
                        this.parseThen(node);
                        break;
                    }
                }
                ++aii;
            }
            RuleImpl ruleImpl = this.ruleBeingBuilt;
            Object var9_8 = null;
            this.ruleBeingBuilt = null;
            return ruleImpl;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.ruleBeingBuilt = null;
            throw throwable;
        }
    }

    private void parseIf(Node node) throws MalformedXMLException {
        NodeList nodes = node.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node conditionNode = nodes.item(aii);
            if (conditionNode.getNodeType() == 1) {
                String tag = conditionNode.getNodeName().toLowerCase();
                if (tag.equals(TAG_EQUAL)) {
                    this.ruleBeingBuilt.setCondition(this.parseEquality(conditionNode));
                } else if (tag.equals(TAG_AND)) {
                    this.ruleBeingBuilt.setCondition(this.parseAnd(conditionNode));
                } else if (tag.equals(TAG_OR)) {
                    this.ruleBeingBuilt.setCondition(this.parseOr(conditionNode));
                } else if (tag.equals(TAG_NOT)) {
                    this.ruleBeingBuilt.setCondition(this.parseNot(conditionNode));
                } else if (tag.equals(TAG_IFTRUE)) {
                    this.ruleBeingBuilt.setCondition(this.parseIfTrue(conditionNode));
                } else if (tag.equals(TAG_REFERENCE)) {
                    this.ruleBeingBuilt.setCondition(this.parseReference(conditionNode));
                }
            }
            ++aii;
        }
    }

    private void parseThen(Node node) throws MalformedXMLException {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        String effectorName = null;
        Node name = node.getAttributes().getNamedItem(ATTRIB_EFFECTOR);
        if (name != null) {
            effectorName = name.getNodeValue();
        }
        NodeList nodes = node.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            String tag;
            Node conditionNode = nodes.item(aii);
            if (conditionNode.getNodeType() == 1 && (tag = conditionNode.getNodeName().toLowerCase()).equals(TAG_ASSIGN)) {
                assignments.add(this.parseAssign(conditionNode));
            }
            ++aii;
        }
        this.ruleBeingBuilt.setResult(new ResultImpl(assignments, effectorName, this.ruleBeingBuilt.getName()));
    }

    private Assignment parseAssign(Node node) throws MalformedXMLException {
        Assignment assignment = null;
        String variableName = node.getAttributes().getNamedItem("var").getNodeValue();
        this.ruleBeingBuilt.ruleSetsVariable(variableName);
        NodeList nodeList = node.getChildNodes();
        int aii = 0;
        while (aii < nodeList.getLength()) {
            Node subNode = nodeList.item(aii);
            if (subNode.getNodeType() == 1) {
                String tag = subNode.getNodeName().toLowerCase();
                if (tag.equals(TAG_VALUE)) {
                    assignment = new AssignmentLiteral(variableName, CommonXMLParser.gatherTextContents(subNode));
                } else if (tag.equals("var")) {
                    String variableName2 = CommonXMLParser.gatherTextContents(subNode);
                    this.ruleBeingBuilt.ruleReferencesVariable(variableName2);
                    assignment = new AssignmentVariable(variableName, variableName2);
                } else if (tag.equals("sensor")) {
                    assignment = new AssignmentSensor(variableName, CommonXMLParser.gatherTextContents(subNode));
                }
            }
            ++aii;
        }
        return assignment;
    }

    private Condition parseEquality(Node node) throws MalformedXMLException {
        String variableName = null;
        String sensorName = null;
        Or condition = new Or();
        Node n = node.getAttributes().getNamedItem("var");
        if (n == null) {
            n = node.getAttributes().getNamedItem("sensor");
            if (n == null) {
                throw new MalformedXMLException("equalilty tag specified without 'var' or 'sensor' attr");
            }
            sensorName = n.getNodeValue();
        } else {
            variableName = n.getNodeValue();
            this.ruleBeingBuilt.ruleReferencesVariable(variableName);
        }
        NodeList nodeList = node.getChildNodes();
        int aii = 0;
        while (aii < nodeList.getLength()) {
            Node subNode = nodeList.item(aii);
            if (subNode.getNodeType() == 1) {
                String variableName2;
                String tag = subNode.getNodeName().toLowerCase();
                if (variableName != null) {
                    if (tag.equals(TAG_VALUE)) {
                        condition.addChild(new VariableEqualityLiteral(variableName, CommonXMLParser.gatherTextContents(subNode)));
                    } else if (tag.equals("sensor")) {
                        condition.addChild(new VariableEqualitySensor(variableName, CommonXMLParser.gatherTextContents(subNode)));
                    } else if (tag.equals("var")) {
                        variableName2 = CommonXMLParser.gatherTextContents(subNode);
                        this.ruleBeingBuilt.ruleReferencesVariable(variableName2);
                        condition.addChild(new VariableEqualityVariable(variableName, variableName2));
                    }
                } else if (tag.equals(TAG_VALUE)) {
                    condition.addChild(new SensorEqualityLiteral(sensorName, CommonXMLParser.gatherTextContents(subNode)));
                } else if (tag.equals("sensor")) {
                    condition.addChild(new SensorEqualitySensor(sensorName, CommonXMLParser.gatherTextContents(subNode)));
                } else if (tag.equals("var")) {
                    variableName2 = CommonXMLParser.gatherTextContents(subNode);
                    this.ruleBeingBuilt.ruleReferencesVariable(variableName2);
                    condition.addChild(new SensorEqualityVariable(sensorName, variableName2));
                }
            }
            ++aii;
        }
        if (condition.getChildren().size() == 1) {
            return (Condition)condition.getChildren().get(0);
        }
        return condition;
    }

    private Condition parseAnd(Node node) throws MalformedXMLException {
        And and = new And();
        this.parseParentCondition(and, node);
        return and;
    }

    private Condition parseOr(Node node) throws MalformedXMLException {
        Or or = new Or();
        this.parseParentCondition(or, node);
        return or;
    }

    private Condition parseNot(Node node) throws MalformedXMLException {
        Not not = new Not();
        this.parseParentCondition(not, node);
        return not;
    }

    private Condition parseIfTrue(Node node) throws MalformedXMLException {
        Node name = node.getAttributes().getNamedItem(ATTRIB_EFFECTOR);
        IfTrue iftrue = new IfTrue(name.getNodeValue());
        this.parseParentCondition(iftrue, node);
        return iftrue;
    }

    private Condition parseReference(Node node) throws MalformedXMLException {
        return new Reference(CommonXMLParser.gatherTextContents(node));
    }

    private void parseParentCondition(ParentCondition parent, Node node) throws MalformedXMLException {
        NodeList nodeList = node.getChildNodes();
        int aii = 0;
        while (aii < nodeList.getLength()) {
            Node subnode = nodeList.item(aii);
            if (subnode.getNodeType() == 1) {
                String tag = subnode.getNodeName().toLowerCase();
                if (tag.equals(TAG_EQUAL)) {
                    parent.addChild(this.parseEquality(subnode));
                } else if (tag.equals(TAG_AND)) {
                    parent.addChild(this.parseAnd(subnode));
                } else if (tag.equals(TAG_OR)) {
                    parent.addChild(this.parseOr(subnode));
                } else if (tag.equals(TAG_NOT)) {
                    parent.addChild(this.parseNot(subnode));
                } else if (tag.equals(TAG_IFTRUE)) {
                    parent.addChild(this.parseIfTrue(subnode));
                } else if (tag.equals(TAG_REFERENCE)) {
                    parent.addChild(this.parseReference(subnode));
                }
            }
            ++aii;
        }
    }

    public static boolean validBoolean(String value) {
        return value.toLowerCase().equals("true") || value.toLowerCase().equals("false");
    }

    public static boolean validInteger(String value) {
        try {
            Integer.valueOf(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean validString(String value) {
        return true;
    }

    private static boolean doTest(int operation, String v1, String vtype1, String v2, String vtype2) throws ValueException, ValueTypeMismatchException, StateTransitionSupportException {
        if (!vtype1.equals(vtype2)) {
            throw new ValueTypeMismatchException("variable type mismatch[" + v1 + "," + v2 + "]");
        }
        switch (operation) {
            case 0: {
                return v1.compareTo(v2) == 0;
            }
            case 2: {
                return v1.compareTo(v2) > 0;
            }
            case 1: {
                return v1.compareTo(v2) < 0;
            }
        }
        throw new StateTransitionSupportException("unknown opereration type:" + operation);
    }

    private static boolean doTestNormalize(int operation, String v1, String vtype1, String v2, String vtype2) throws ValueException, ValueTypeMismatchException, StateTransitionSupportException {
        String normV1 = v1.toLowerCase();
        String normV2 = v2.toLowerCase();
        return StateTransitionSupport.doTest(operation, normV1, vtype1, normV2, vtype2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fireSensor(Sensor sensor, List allowableValues, ContextImpl context) throws SensorException, ValueException {
        String result = null;
        boolean rw = context.isReadOnly();
        try {
            context.setReadOnly(true);
            try {
                result = sensor.fire(context);
            }
            catch (UnresolvableValueSensorException e) {
                throw new UnresolvableValueException(e);
            }
            if (allowableValues != null) {
                Iterator it = allowableValues.iterator();
                boolean found = false;
                while (it.hasNext()) {
                    if (!it.next().equals(result)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    Trace.trace(TRACE_MASKT, "<-! invalid value [" + result + "] returned from sensor: " + sensor);
                    throw new ValueException("Invalid value [" + result + "] returned from sensor: " + sensor);
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            context.setReadOnly(rw);
            throw throwable;
        }
        context.setReadOnly(rw);
        return result;
    }

    private class ValueSet
    implements Serializable {
        private List values = null;
        private String name = "";
        private String desc = "";
        private String type = "string";
        private List listeners = null;

        public List getValues() {
            return this.values;
        }

        public void resetValues() {
            this.setValues(null);
        }

        public void setValues(List values) {
            this.values = values;
            if (this.listeners != null) {
                Iterator it = this.listeners.iterator();
                while (it.hasNext()) {
                    ((ValueSetListener)it.next()).valueSetValuesChanged(this);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void addListener(ValueSetListener vsl) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(vsl);
        }

        public void removeListener(ValueSetListener vsl) {
            if (this.listeners != null) {
                this.listeners.remove(vsl);
            }
        }
    }

    private static class EngineImpl
    implements Engine {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List fire(Context _context) throws StateTransitionSupportException {
            LinkedList<ResultImpl> list;
            ContextImpl context;
            block11: {
                context = (ContextImpl)_context;
                boolean done = false;
                list = new LinkedList<ResultImpl>();
                try {
                    try {
                        Map rules = context.getRules();
                        Collection c = rules.values();
                        Iterator it = c.iterator();
                        context.engineRunning(true);
                        while (true) {
                            if (!it.hasNext()) {
                                context.commit();
                                done = true;
                                break;
                            }
                            RuleImpl rule = (RuleImpl)it.next();
                            Trace.trace(StateTransitionSupport.TRACE_MASKD, "evaluating rule:" + rule);
                            rule.evaluate(context);
                            if (rule.isSatisfied()) {
                                Trace.trace(StateTransitionSupport.TRACE_MASKF, "the following rule evaluated to TRUE:" + rule + ", internal=" + rule.isInternal());
                                ResultImpl result = rule.getResult();
                                if (rule.isInternal()) continue;
                                list.add(result);
                                continue;
                            }
                            Trace.trace(StateTransitionSupport.TRACE_MASKD, "the following rule evaluated to FALSE:" + rule);
                        }
                    }
                    catch (StateTransitionSupportException e) {
                        context.rollback();
                        done = true;
                        throw e;
                    }
                    catch (Exception e) {
                        context.rollback();
                        done = true;
                        throw new StateTransitionSupportException(e);
                    }
                    Object var11_12 = null;
                    if (done) break block11;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (!done) {
                        context.rollback();
                    }
                    context.engineRunning(false);
                    throw throwable;
                }
                context.rollback();
            }
            context.engineRunning(false);
            return list;
        }
    }

    private static class ResultImpl
    implements Result,
    Serializable {
        private List assignments;
        private String effectorName = null;
        private String ruleName;

        public ResultImpl(List assignments, String effectorName, String ruleName) {
            this.assignments = assignments;
            this.effectorName = effectorName;
            this.ruleName = ruleName;
        }

        public void fireEffector(Context _context) throws EffectorException, ValueException {
            ContextImpl context = (ContextImpl)_context;
            if (this.effectorName != null) {
                EffectorData ed = context.getEffectorData(this.effectorName);
                if (ed != null) {
                    Effector ef = ed.instantiate();
                    ef.fire(context);
                } else {
                    Trace.trace(StateTransitionSupport.TRACE_MASKT, "<-! StateTransitionSupport.fireEffector undefined effector: " + this.effectorName);
                    throw new EffectorException("attempt to fire and undefined effector: " + this.effectorName);
                }
            }
        }

        public void fire(ContextImpl context) throws StateTransitionSupportException {
            if (this.assignments != null) {
                Iterator it = this.assignments.iterator();
                while (it.hasNext()) {
                    ((Assignment)it.next()).fire(context);
                }
            }
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public String toString() {
            return "Result:effector[" + this.effectorName + "],rule[" + this.ruleName + "]";
        }
    }

    private static class EffectorData
    extends ClassData
    implements Serializable {
        private String name = null;
        private String desc = null;
        private String type = null;
        private boolean staticInstance = true;
        private transient Effector effector = null;

        public EffectorData() {
        }

        public EffectorData(String name) {
            this.setName(name);
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getDescription() {
            return this.desc;
        }

        public Effector instantiate() throws EffectorException {
            if (!this.staticInstance || this.effector == null) {
                try {
                    this.effector = (Effector)ClassUtils.instantiate(this);
                }
                catch (Exception e) {
                    Trace.trace(StateTransitionSupport.TRACE_MASKT, "<-! EffectorData.instantiate Exception caught trying to instantiate Effector '" + this.getName() + "', exception[" + e + "]");
                    Trace.trace(StateTransitionSupport.TRACE_MASKT, e);
                    throw new EffectorException(e);
                }
            }
            return this.effector;
        }

        public void setStaticInstance(boolean staticInstance) {
            if (!staticInstance) {
                this.effector = null;
            }
            this.staticInstance = staticInstance;
        }

        public boolean isStaticInstance() {
            return this.staticInstance;
        }
    }

    private static class SensorData
    extends ClassData
    implements ValueSetListener,
    Serializable {
        private String name = null;
        private String desc = null;
        private String type = null;
        private boolean staticInstance = true;
        private transient Sensor sensor = null;
        private ValueSetListener vsl = new ValueSetListenerImpl();

        public SensorData() {
        }

        public SensorData(String name) {
            this.setName(name);
        }

        public void clearValueSets() {
            this.vsl.clearValueSets();
        }

        public void addValueSet(ValueSet vs) {
            this.vsl.addValueSet(vs);
        }

        public void valueSetValuesChanged(ValueSet updatedVs) {
            this.vsl.valueSetValuesChanged(updatedVs);
        }

        public List getAllowableValues() {
            return this.vsl.getAllowableValues();
        }

        public void resetValues() {
            this.vsl.clearValueSets();
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public Sensor instantiate() throws SensorException {
            if (!this.staticInstance || this.sensor == null) {
                try {
                    this.sensor = (Sensor)ClassUtils.instantiate(this);
                }
                catch (Exception e) {
                    Trace.trace(StateTransitionSupport.TRACE_MASKT, "<-! SensorData.instantiate Exception caught trying to instantiate Sensor '" + this.getName() + "', exception[" + e + "]");
                    Trace.trace(StateTransitionSupport.TRACE_MASKT, e);
                    throw new SensorException(e);
                }
            }
            return this.sensor;
        }

        public void setStaticInstance(boolean staticInstance) {
            this.staticInstance = staticInstance;
        }

        public boolean isStaticInstance() {
            return this.staticInstance;
        }
    }

    private static class RuleImpl
    implements Rule {
        private String name;
        private boolean alreadyEvaluated = false;
        private boolean beingEvaluated = false;
        private boolean ruleSatisfied = false;
        private boolean internalRule = false;
        private ResultImpl result = null;
        private Condition condition = null;
        private List varsReferenced = new ArrayList();
        private List varsSet = new ArrayList();

        public RuleImpl(String name) {
            this.setName(name);
        }

        public synchronized boolean evaluate(Context _context) throws StateTransitionSupportException {
            ContextImpl context = (ContextImpl)_context;
            if (this.beingEvaluated) {
                throw new StateTransitionSupportException("evaluation loop detected in rule[" + this.getName() + "]");
            }
            if (!this.alreadyEvaluated) {
                this.ruleSatisfied = false;
                this.beingEvaluated = true;
                if (this.condition != null) {
                    this.ruleSatisfied = this.condition.evaluate(context);
                    if (this.ruleSatisfied && this.result != null) {
                        this.result.fire(context);
                    }
                }
                this.beingEvaluated = false;
                this.alreadyEvaluated = true;
            }
            return this.ruleSatisfied;
        }

        public ResultImpl getResult() {
            return this.result;
        }

        public void setResult(ResultImpl result) {
            this.result = result;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public void setName(String ruleName) {
            this.name = ruleName;
        }

        public String getName() {
            return this.name;
        }

        public void reset() {
            this.alreadyEvaluated = false;
            this.beingEvaluated = false;
            this.ruleSatisfied = false;
        }

        public boolean isAlreadyEvaluated() {
            return this.alreadyEvaluated;
        }

        public boolean isBeingEvaluated() {
            return this.beingEvaluated;
        }

        public boolean isSatisfied() {
            return this.ruleSatisfied;
        }

        public void ruleSetsVariable(String variableName) {
            if (!this.varsSet.contains(variableName)) {
                this.varsSet.add(variableName);
            }
        }

        public void ruleReferencesVariable(String variableName) {
            if (!this.varsReferenced.contains(variableName)) {
                this.varsReferenced.add(variableName);
            }
        }

        public boolean isVariableSet(String variableName) {
            return this.varsSet.contains(variableName);
        }

        public boolean isVariableReferenced(String variableName) {
            return this.varsReferenced.contains(variableName);
        }

        public void setInternal(boolean internalRule) {
            this.internalRule = internalRule;
        }

        public boolean isInternal() {
            return this.internalRule;
        }

        public String toString() {
            String debug = "rule, name:" + this.getName() + ",internal:" + this.isInternal();
            debug = debug + ", vars set:";
            Iterator it = this.varsSet.iterator();
            while (it.hasNext()) {
                debug = debug + "[" + (String)it.next() + "]";
            }
            debug = debug + ", vars referenced:";
            it = this.varsReferenced.iterator();
            while (it.hasNext()) {
                debug = debug + "[" + (String)it.next() + "]";
            }
            return debug;
        }
    }

    private static interface Rule
    extends Serializable {
        public boolean evaluate(Context var1) throws StateTransitionSupportException;
    }

    private static class ContextImpl
    implements Context {
        public static boolean VARIABLE_RESOLUTION_ENABLED = false;
        private Map rules;
        private Map variables;
        private Map valueSets;
        private Map sensorDataObjects;
        private Map effectorDataObjects;
        private transient Map userData = null;
        private boolean readOnlyContext;
        private boolean engineIsRunning;
        private Context parentContext = null;

        public ContextImpl() {
            this.rules = new HashMap();
            this.variables = new HashMap();
            this.valueSets = new HashMap();
            this.sensorDataObjects = new HashMap();
            this.effectorDataObjects = new HashMap();
            this.readOnlyContext = false;
            this.engineIsRunning = false;
        }

        public ContextImpl(PersistentData pd) {
            PersistentDataImpl pdi = (PersistentDataImpl)pd;
            this.rules = pdi.rules;
            this.sensorDataObjects = pdi.sensorDataObjects;
            this.effectorDataObjects = pdi.effectorDataObjects;
            this.readOnlyContext = pdi.readOnlyContext;
            this.engineIsRunning = pdi.engineIsRunning;
            this.valueSets = pdi.valueSets;
            this.variables = new HashMap();
            Iterator it = pdi.variables.values().iterator();
            while (it.hasNext()) {
                VariableImpl vi = (VariableImpl)it.next();
                vi.initChangeSupport();
                this.addVariable(vi.getName(), vi);
            }
        }

        public PersistentData getPersistentData() {
            PersistentDataImpl pdi = new PersistentDataImpl();
            pdi.rules = this.rules;
            pdi.variables = this.variables;
            pdi.valueSets = this.valueSets;
            pdi.sensorDataObjects = this.sensorDataObjects;
            pdi.effectorDataObjects = this.effectorDataObjects;
            pdi.readOnlyContext = this.readOnlyContext;
            pdi.engineIsRunning = this.engineIsRunning;
            return pdi;
        }

        private void setParentContext(Context parentContext) {
            this.parentContext = parentContext;
        }

        private Context getParentContext() {
            return this.parentContext;
        }

        public boolean isUpgradeData() {
            return false;
        }

        public void setUserData(Map userData) {
            this.userData = userData;
        }

        public Map getUserData() {
            return this.userData;
        }

        private void addVariable(String varname, Variable _variable) {
            VariableImpl variable = (VariableImpl)_variable;
            variable.addChangeListener(new ChangeListener());
            this.variables.put(varname, variable);
        }

        private void removeVariable(String varname) {
            this.variables.remove(varname);
        }

        public Variable getVariable(String variableName) {
            Variable v = (Variable)this.variables.get(variableName);
            if ((v == null || v.isGlobal()) && this.parentContext != null && (v = this.parentContext.getVariable(variableName)) != null && !v.isGlobal()) {
                v = null;
            }
            return v;
        }

        private void addValueSet(String valueSetName, ValueSet valueSet) {
            this.valueSets.put(valueSetName, valueSet);
        }

        public ValueSet getValueSet(String valueSetName) {
            return (ValueSet)this.valueSets.get(valueSetName);
        }

        private void addRule(String ruleName, RuleImpl rule) {
            this.rules.put(ruleName, rule);
        }

        private void removeRule(String ruleName) {
            this.rules.remove(ruleName);
        }

        private Map getRules() {
            return Collections.unmodifiableMap(this.rules);
        }

        private RuleImpl getRule(String ruleName) {
            return (RuleImpl)this.rules.get(ruleName);
        }

        private void addSensorData(String sensorName, SensorData sensorData) {
            this.sensorDataObjects.put(sensorName, sensorData);
        }

        private void removeSensorData(String sensorName) {
            this.sensorDataObjects.remove(sensorName);
        }

        private SensorData getSensorData(String sensorName) {
            return (SensorData)this.sensorDataObjects.get(sensorName);
        }

        private void addEffectorData(String effectorName, EffectorData effectorData) {
            this.effectorDataObjects.put(effectorName, effectorData);
        }

        private void removeEffectorData(String effectorName) {
            this.effectorDataObjects.remove(effectorName);
        }

        private EffectorData getEffectorData(String effectorName) {
            return (EffectorData)this.effectorDataObjects.get(effectorName);
        }

        private void engineRunning(boolean engineIsRunning) {
            this.engineIsRunning = engineIsRunning;
        }

        private void commit() {
            Collection c;
            Collection vars = this.variables.values();
            if (vars != null) {
                Iterator it = vars.iterator();
                while (it.hasNext()) {
                    ((VariableImpl)it.next()).commit();
                }
            }
            if ((c = this.rules.values()) != null) {
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    RuleImpl rule = (RuleImpl)it.next();
                    rule.reset();
                }
            }
        }

        private void rollback() {
            Collection c;
            Collection vars = this.variables.values();
            if (vars != null) {
                Iterator it = vars.iterator();
                while (it.hasNext()) {
                    ((VariableImpl)it.next()).rollback();
                }
            }
            if ((c = this.rules.values()) != null) {
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    RuleImpl rule = (RuleImpl)it.next();
                    rule.reset();
                }
            }
        }

        private void setReadOnly(boolean readOnlyContext) {
            this.readOnlyContext = readOnlyContext;
        }

        private boolean isReadOnly() {
            return this.readOnlyContext;
        }

        private class ChangeListener
        implements VetoableChangeListener {
            private ChangeListener() {
            }

            public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
                if (e.getPropertyName().equals(PROPERTY_VALUE_CHANGED)) {
                    VariableImpl v = (VariableImpl)e.getSource();
                    String committedValue = (String)e.getOldValue();
                    String newValue = v.getValue();
                    String uncommittedValue = (String)e.getNewValue();
                    if (ContextImpl.this.readOnlyContext) {
                        Trace.trace(StateTransitionSupport.TRACE_MASKF, "Variable update attempted against R/O context: variable:" + v.getName());
                        throw new PropertyVetoException("Variable update attempted against R/O context: variable:" + v.getName(), e);
                    }
                    if (ContextImpl.this.engineIsRunning) {
                        if (committedValue != uncommittedValue && newValue != uncommittedValue) {
                            Trace.trace(StateTransitionSupport.TRACE_MASKF, "Variable [" + v.getName() + "] already set during current engine execution.  Previously set value:" + uncommittedValue + ",attempted value:" + newValue);
                            throw new PropertyVetoException("Variable [" + v.getName() + "] already set during current engine execution.  Previously set value:" + uncommittedValue + ",attempted value:" + newValue, e);
                        }
                        Trace.trace(StateTransitionSupport.TRACE_MASKF, "Variable [" + v.getName() + "] updated with value:" + newValue);
                    } else {
                        Trace.trace(StateTransitionSupport.TRACE_MASKF, "Variable [" + v.getName() + "] updated outside control of Engine - value committed:" + newValue);
                        v.commit();
                    }
                }
            }
        }

        public static class PersistentDataImpl
        implements PersistentData {
            public Map rules;
            public Map variables;
            public Map valueSets;
            public Map sensorDataObjects;
            public Map effectorDataObjects;
            public boolean readOnlyContext;
            public boolean engineIsRunning;
            static final long serialVersionUID = -1L;
        }
    }

    private static class AssignmentVariable
    implements Assignment {
        private String variableName;
        private String variableName2;

        public AssignmentVariable(String variableName, String variableName2) {
            this.variableName = variableName;
            this.variableName2 = variableName2;
        }

        public void fire(ContextImpl context) throws StateTransitionSupportException {
            VariableImpl variable = VariableOperator.lookupVariable(this.variableName, context);
            VariableImpl variable2 = VariableOperator.resolveVariable(this.variableName2, context);
            variable.setValue(variable2.getValue());
        }
    }

    private static class AssignmentSensor
    implements Assignment {
        private String variableName;
        private String sensorName;

        public AssignmentSensor(String variableName, String sensorName) {
            this.variableName = variableName;
            this.sensorName = sensorName;
        }

        public void fire(ContextImpl context) throws StateTransitionSupportException {
            VariableImpl variable = VariableOperator.lookupVariable(this.variableName, context);
            String type = variable.getType();
            SensorData sensorData = context.getSensorData(this.sensorName);
            if (sensorData == null) {
                throw new SensorCreationException("sensor[" + this.sensorName + "] not defined");
            }
            Sensor sensor = sensorData.instantiate();
            variable.setValue(StateTransitionSupport.fireSensor(sensor, sensorData.getAllowableValues(), context));
        }
    }

    private static class AssignmentLiteral
    implements Assignment {
        private String literalValue;
        private String variableName;

        public AssignmentLiteral(String variableName, String literalValue) {
            this.variableName = variableName;
            this.literalValue = literalValue;
        }

        public void fire(ContextImpl context) throws StateTransitionSupportException {
            VariableImpl variable = VariableOperator.lookupVariable(this.variableName, context);
            variable.setValue(this.literalValue);
        }
    }

    private static interface Assignment
    extends Serializable {
        public void fire(ContextImpl var1) throws StateTransitionSupportException;
    }

    private static class StringVariable
    extends VariableImpl {
        public StringVariable(String name) {
            this.setName(name);
        }

        public StringVariable() {
        }

        public String getType() {
            return "string";
        }

        public boolean isValidForType(String value) {
            return StateTransitionSupport.validString(value);
        }

        public void validate(String value) throws ValueException {
            if (!this.isAllowable(value)) {
                throw new ValueException("value [" + value + "] for String variable[" + this.getName() + "] is not defined within the set of allowable values");
            }
        }
    }

    private static class IntegerVariable
    extends VariableImpl {
        Integer min = null;
        Integer max = null;

        public IntegerVariable(String name) {
            this.setName(name);
        }

        public IntegerVariable() {
        }

        public String getType() {
            return "integer";
        }

        public void setMin(String min) throws ValueException {
            try {
                this.min = Integer.valueOf(min);
            }
            catch (NumberFormatException e) {
                throw new ValueException(e);
            }
        }

        public void setMax(String max) throws ValueException {
            try {
                this.max = Integer.valueOf(max);
            }
            catch (NumberFormatException e) {
                throw new ValueException(e);
            }
        }

        public boolean isValidForType(String value) {
            return StateTransitionSupport.validInteger(value);
        }

        public void validate(String value) throws ValueException {
            if (!this.isAllowable(value)) {
                throw new ValueException("value [" + value + "] for Integer variable[" + this.getName() + "] is not defined within the set of allowable values");
            }
            try {
                Integer ival = Integer.valueOf(value);
                if (this.min != null && ival < this.min) {
                    throw new ValueException("value [" + value + "] for Integer variable[" + this.getName() + "] is less than specified MIN");
                }
                if (this.max != null && ival > this.max) {
                    throw new ValueException("value [" + value + "] for Integer variable[" + this.getName() + "] is less than specified MAX");
                }
            }
            catch (NumberFormatException e) {
                throw new ValueException(e);
            }
        }
    }

    private static class BooleanVariable
    extends VariableImpl {
        public BooleanVariable(String name) {
            this.setName(name);
        }

        public BooleanVariable() {
        }

        public String getType() {
            return "boolean";
        }

        public boolean isValidForType(String value) {
            return StateTransitionSupport.validBoolean(value);
        }

        public void validate(String value) throws ValueException {
            if (!this.isValidForType(value)) {
                throw new ValueException("invalid boolean value setting [" + value + "]");
            }
        }
    }

    private static abstract class VariableImpl
    implements Variable,
    ValueSetListener {
        private String name = null;
        private String desc = null;
        private String currentValue = null;
        private String committedValue = null;
        protected String type = null;
        protected boolean global = false;
        protected transient VetoableChangeSupport vetoChangeSupport = null;
        private ValueSetListener vsl = new ValueSetListenerImpl();

        public VariableImpl() {
            this.initChangeSupport();
        }

        public boolean isGlobal() {
            return this.global;
        }

        private void setGlobal(boolean global) {
            this.global = global;
        }

        public void clearValueSets() {
            this.vsl.clearValueSets();
        }

        public void addValueSet(ValueSet vs) {
            this.vsl.addValueSet(vs);
        }

        public void valueSetValuesChanged(ValueSet updatedVs) {
            this.vsl.valueSetValuesChanged(updatedVs);
        }

        public List getAllowableValues() {
            return this.vsl.getAllowableValues();
        }

        public void initChangeSupport() {
            this.vetoChangeSupport = new VetoableChangeSupport(this);
        }

        public void resetValues() {
            this.clearValueSets();
            this.currentValue = null;
            this.committedValue = null;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getDescription() {
            return this.desc;
        }

        public synchronized void setValue(String value) throws ValueException, UpdateNotAllowedException {
            String saveCurrentValue = this.currentValue;
            try {
                if (this.currentValue != value) {
                    this.validate(value);
                    this.currentValue = value;
                }
                this.vetoChangeSupport.fireVetoableChange(new PropertyChangeEvent(this, PROPERTY_VALUE_CHANGED, this.committedValue, saveCurrentValue));
            }
            catch (PropertyVetoException e) {
                this.currentValue = saveCurrentValue;
                throw new UpdateNotAllowedException(e);
            }
        }

        public synchronized String getValue() {
            return this.currentValue;
        }

        public String getType() {
            return this.type;
        }

        public boolean isAllowable(String value) {
            List allowableVals = this.getAllowableValues();
            if (allowableVals != null) {
                Iterator it = allowableVals.iterator();
                boolean allowable = false;
                while (it.hasNext() && !allowable) {
                    if (!value.equals((String)it.next())) continue;
                    allowable = true;
                }
                return allowable;
            }
            return true;
        }

        public abstract boolean isValidForType(String var1);

        public abstract void validate(String var1) throws ValueException;

        public synchronized void commit() {
            this.committedValue = this.currentValue;
        }

        public synchronized void rollback() {
            this.currentValue = this.committedValue;
        }

        public void addChangeListener(VetoableChangeListener listener) {
            this.vetoChangeSupport.addVetoableChangeListener(listener);
        }

        public void removeChangeListener(VetoableChangeListener listener) {
            this.vetoChangeSupport.removeVetoableChangeListener(listener);
        }

        public String toString() {
            return "[name:" + this.name + ",current value:" + this.currentValue + ",committed value:" + this.committedValue + ",description:" + this.desc + ",type:" + this.getType() + "]";
        }
    }

    private static final class ValueSetListenerImpl
    implements ValueSetListener {
        private List valueSets = null;
        private List allowableVals = null;

        private ValueSetListenerImpl() {
        }

        public void clearValueSets() {
            this.valueSets = null;
            this.allowableVals = null;
        }

        public void addValueSet(ValueSet vs) {
            if (this.valueSets == null) {
                this.valueSets = new ArrayList();
                this.allowableVals = new ArrayList();
            }
            this.valueSets.add(vs);
            this.allowableVals.addAll(vs.getValues());
            vs.addListener(this);
        }

        public void valueSetValuesChanged(ValueSet updatedVs) {
            if (this.valueSets != null) {
                if (!this.valueSets.contains(updatedVs)) {
                    updatedVs.removeListener(this);
                }
                this.allowableVals = new ArrayList();
                Iterator it = this.valueSets.iterator();
                while (it.hasNext()) {
                    ValueSet vs = (ValueSet)it.next();
                    if (vs.getValues() == null) continue;
                    this.allowableVals.addAll(vs.getValues());
                }
            } else {
                this.allowableVals = null;
            }
        }

        public List getAllowableValues() {
            return this.allowableVals;
        }
    }

    private static interface ValueSetListener {
        public void clearValueSets();

        public void addValueSet(ValueSet var1);

        public void valueSetValuesChanged(ValueSet var1);

        public List getAllowableValues();
    }

    private static class VariableOperator {
        private VariableOperator() {
        }

        private static VariableImpl lookupVariable(String variableNameToLookup, ContextImpl context) throws UndefinedVariableException {
            VariableImpl v = (VariableImpl)context.getVariable(variableNameToLookup);
            if (v == null) {
                throw new UndefinedVariableException("variable[" + variableNameToLookup + "] is not defined in the context");
            }
            return v;
        }

        private static VariableImpl resolveVariable(String variableNameToResolve, ContextImpl context) throws UnresolvableValueException, StateTransitionSupportException {
            VariableImpl v = VariableOperator.lookupVariable(variableNameToResolve, context);
            if (v.getValue() == null) {
                if (!ContextImpl.VARIABLE_RESOLUTION_ENABLED) {
                    throw new UnresolvableValueException("value not set for for variable :" + variableNameToResolve);
                }
                throw new StateTransitionSupportException("implicit variable resolution is not implemented");
            }
            return v;
        }
    }

    private static class IfTrue
    extends ParentCondition {
        private String effectorName;

        public IfTrue(String effectorName) {
            this.effectorName = effectorName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evaluate(ContextImpl context) throws StateTransitionSupportException {
            Condition c = (Condition)this.getChildren().get(0);
            boolean result = c.evaluate(context);
            if (result) {
                EffectorData ed = context.getEffectorData(this.effectorName);
                if (ed == null) {
                    throw new EffectorCreationException("undefined effector: " + this.effectorName);
                }
                Effector ef = ed.instantiate();
                boolean rw = context.isReadOnly();
                try {
                    context.setReadOnly(true);
                    ef.fire(context);
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    context.setReadOnly(rw);
                    throw throwable;
                }
                context.setReadOnly(rw);
                {
                }
            }
            return result;
        }
    }

    private static class Reference
    implements Condition {
        private String ruleName;

        public Reference(String ruleName) {
            this.ruleName = ruleName;
        }

        public boolean evaluate(ContextImpl context) throws StateTransitionSupportException {
            RuleImpl rule = context.getRule(this.ruleName);
            if (this.ruleName == null) {
                throw new ValueException("rule name [" + this.ruleName + "] in reference tag not found");
            }
            boolean truth = rule.evaluate(context);
            Trace.trace(StateTransitionSupport.TRACE_MASKD, "<<--REF-->>" + this.ruleName + "[truth=" + truth + "]");
            return truth;
        }

        public String toString() {
            return "Reference[" + this.ruleName + "]";
        }
    }

    private static class Not
    extends ParentCondition {
        public boolean evaluate(ContextImpl context) throws StateTransitionSupportException {
            Condition c = (Condition)this.getChildren().get(0);
            boolean truth = !c.evaluate(context);
            Trace.trace(StateTransitionSupport.TRACE_MASKD, "<<--NOT-->>" + c.toString() + "[truth=" + truth + "]");
            return truth;
        }

        public String toString() {
            return "Not[]";
        }
    }

    private static class Or
    extends ParentCondition {
        public boolean evaluate(ContextImpl context) throws StateTransitionSupportException {
            Iterator it = this.getChildren().iterator();
            boolean truth = false;
            Trace.trace(StateTransitionSupport.TRACE_MASKD, "-->OR");
            while (!truth && it.hasNext()) {
                Condition c = (Condition)it.next();
                truth = c.evaluate(context);
                Trace.trace(StateTransitionSupport.TRACE_MASKD, "<<--OR-->>" + c.toString() + "[truth=" + truth + "]");
            }
            Trace.trace(StateTransitionSupport.TRACE_MASKD, "<--OR[" + truth + "]");
            return truth;
        }

        public String toString() {
            return "Or[]";
        }
    }

    private static class And
    extends ParentCondition {
        public boolean evaluate(ContextImpl context) throws StateTransitionSupportException {
            Iterator it = this.getChildren().iterator();
            boolean truth = true;
            Trace.trace(StateTransitionSupport.TRACE_MASKD, "-->AND");
            while (truth && it.hasNext()) {
                Condition c = (Condition)it.next();
                truth = c.evaluate(context);
                Trace.trace(StateTransitionSupport.TRACE_MASKD, "<<--AND-->>" + c.toString() + "[truth=" + truth + "]");
            }
            Trace.trace(StateTransitionSupport.TRACE_MASKD, "<--AND[" + truth + "]");
            return truth;
        }

        public String toString() {
            return "And[]";
        }
    }

    private class SensorGreaterThanSensor
    extends SensorTestAgainstSensor {
        public SensorGreaterThanSensor(String sensorName1, String sensorName2) {
            super(sensorName1, sensorName2);
            this.operation = 2;
        }
    }

    private class SensorLessThanSensor
    extends SensorTestAgainstSensor {
        public SensorLessThanSensor(String sensorName1, String sensorName2) {
            super(sensorName1, sensorName2);
            this.operation = 1;
        }
    }

    private class SensorEqualitySensor
    extends SensorTestAgainstSensor {
        public SensorEqualitySensor(String sensorName1, String sensorName2) {
            super(sensorName1, sensorName2);
            this.operation = 0;
        }
    }

    private static abstract class SensorTestAgainstSensor
    implements Condition {
        private String sensorName1;
        private String sensorName2;
        protected int operation;

        public SensorTestAgainstSensor(String sensorName1, String sensorName2) {
            this.sensorName1 = sensorName1;
            this.sensorName2 = sensorName2;
        }

        public boolean evaluate(ContextImpl context) throws StateTransitionSupportException {
            SensorData sensorData1 = context.getSensorData(this.sensorName1);
            if (sensorData1 == null) {
                throw new SensorCreationException("sensor[" + this.sensorName1 + "] not defined");
            }
            Sensor sensor1 = sensorData1.instantiate();
            SensorData sensorData2 = context.getSensorData(this.sensorName2);
            if (sensorData2 == null) {
                throw new SensorCreationException("sensor[" + this.sensorName2 + "] not defined");
            }
            Sensor sensor2 = sensorData2.instantiate();
            try {
                boolean result = StateTransitionSupport.doTest(this.operation, StateTransitionSupport.fireSensor(sensor1, sensorData1.getAllowableValues(), context), sensorData1.getType(), StateTransitionSupport.fireSensor(sensor2, sensorData2.getAllowableValues(), context), sensorData2.getType());
                Trace.trace(StateTransitionSupport.TRACE_MASKD, this.toString() + "[result=" + result + "]");
                return result;
            }
            catch (UnresolvableValueException e) {
                Trace.trace(StateTransitionSupport.TRACE_MASKD, this.toString() + " UnresolvableValueException; return false");
                return false;
            }
        }

        public String toString() {
            return "SensorTestAgainstSensor[" + this.sensorName1 + "][" + this.sensorName2 + "]";
        }
    }

    private class SensorGreaterThanVariable
    extends SensorTestAgainstVariable {
        public SensorGreaterThanVariable(String sensorName, String variableName) {
            super(sensorName, variableName);
            this.operation = 2;
        }
    }

    private class SensorLessThanVariable
    extends SensorTestAgainstVariable {
        public SensorLessThanVariable(String sensorName, String variableName) {
            super(sensorName, variableName);
            this.operation = 1;
        }
    }

    private class SensorEqualityVariable
    extends SensorTestAgainstVariable {
        public SensorEqualityVariable(String sensorName, String variableName) {
            super(sensorName, variableName);
            this.operation = 0;
        }
    }

    private static abstract class SensorTestAgainstVariable
    implements Condition {
        private String variableName;
        private String sensorName;
        protected int operation;

        public SensorTestAgainstVariable(String sensorName, String variableName) {
            this.sensorName = sensorName;
            this.variableName = variableName;
        }

        public boolean evaluate(ContextImpl context) throws StateTransitionSupportException {
            try {
                VariableImpl variable = VariableOperator.resolveVariable(this.variableName, context);
                SensorData sensorData = context.getSensorData(this.sensorName);
                if (sensorData == null) {
                    throw new SensorCreationException("sensor[" + this.sensorName + "] not defined");
                }
                Sensor sensor = sensorData.instantiate();
                boolean result = StateTransitionSupport.doTest(this.operation, StateTransitionSupport.fireSensor(sensor, sensorData.getAllowableValues(), context), sensorData.getType(), variable.getValue(), variable.getType());
                Trace.trace(StateTransitionSupport.TRACE_MASKD, this.toString() + "[result=" + result + "]");
                return result;
            }
            catch (UnresolvableValueException e) {
                Trace.trace(StateTransitionSupport.TRACE_MASKD, this.toString() + " UnresolvableValueException; return false");
                return false;
            }
        }

        public String toString() {
            return "SensorTestAgainstVariable[" + this.sensorName + "][" + this.variableName + "]";
        }
    }

    private class SensorGreaterThanLiteral
    extends SensorTestAgainstLiteral {
        public SensorGreaterThanLiteral(String sensorName, String literalValue) {
            super(sensorName, literalValue);
            this.operation = 2;
        }
    }

    private class SensorLessThanLiteral
    extends SensorTestAgainstLiteral {
        public SensorLessThanLiteral(String sensorName, String literalValue) {
            super(sensorName, literalValue);
            this.operation = 1;
        }
    }

    private class SensorEqualityLiteral
    extends SensorTestAgainstLiteral {
        public SensorEqualityLiteral(String sensorName, String literalValue) {
            super(sensorName, literalValue);
            this.operation = 0;
        }
    }

    private static abstract class SensorTestAgainstLiteral
    implements Condition {
        private String sensorName;
        private String literalValue;
        protected int operation;

        public SensorTestAgainstLiteral(String sensorName, String literalValue) {
            this.sensorName = sensorName;
            this.literalValue = literalValue;
        }

        public boolean evaluate(ContextImpl context) throws StateTransitionSupportException {
            SensorData sensorData = context.getSensorData(this.sensorName);
            if (sensorData == null) {
                throw new SensorCreationException("sensor[" + this.sensorName + "] not defined");
            }
            Sensor sensor = sensorData.instantiate();
            try {
                boolean result = StateTransitionSupport.doTest(this.operation, StateTransitionSupport.fireSensor(sensor, sensorData.getAllowableValues(), context), sensorData.getType(), this.literalValue, sensorData.getType());
                Trace.trace(StateTransitionSupport.TRACE_MASKD, this.toString() + "[result=" + result + "]");
                return result;
            }
            catch (UnresolvableValueException e) {
                Trace.trace(StateTransitionSupport.TRACE_MASKD, this.toString() + " UnresolvableValueException; return false");
                return false;
            }
        }

        public String toString() {
            return "SensorTestAgainstLiteral[" + this.sensorName + "][" + this.literalValue + "]";
        }
    }

    private class VariableGreaterThanSensor
    extends VariableTestAgainstSensor {
        public VariableGreaterThanSensor(String variableName, String sensorName) {
            super(variableName, sensorName);
            this.operation = 2;
        }
    }

    private class VariableLessThanSensor
    extends VariableTestAgainstSensor {
        public VariableLessThanSensor(String variableName, String sensorName) {
            super(variableName, sensorName);
            this.operation = 1;
        }
    }

    private class VariableEqualitySensor
    extends VariableTestAgainstSensor {
        public VariableEqualitySensor(String variableName, String sensorName) {
            super(variableName, sensorName);
            this.operation = 0;
        }
    }

    private static abstract class VariableTestAgainstSensor
    implements Condition {
        private String variableName;
        private String sensorName;
        protected int operation;

        public VariableTestAgainstSensor(String variableName, String sensorName) {
            this.variableName = variableName;
            this.sensorName = sensorName;
        }

        public boolean evaluate(ContextImpl context) throws StateTransitionSupportException {
            try {
                VariableImpl variable = VariableOperator.resolveVariable(this.variableName, context);
                String type = variable.getType();
                SensorData sensorData = context.getSensorData(this.sensorName);
                if (sensorData == null) {
                    throw new SensorCreationException("sensor[" + this.sensorName + "] not defined");
                }
                Sensor sensor = sensorData.instantiate();
                boolean result = StateTransitionSupport.doTest(this.operation, variable.getValue(), type, StateTransitionSupport.fireSensor(sensor, sensorData.getAllowableValues(), context), type);
                Trace.trace(StateTransitionSupport.TRACE_MASKD, this.toString() + "[result=" + result + "]");
                return result;
            }
            catch (UnresolvableValueException e) {
                Trace.trace(StateTransitionSupport.TRACE_MASKD, this.toString() + " UnresolvableValueException; return false");
                return false;
            }
        }

        public String toString() {
            return "VariableTestAgainstSensor[" + this.variableName + "][" + this.sensorName + "]";
        }
    }

    private class VariableGreaterThanVariable
    extends VariableTestAgainstVariable {
        public VariableGreaterThanVariable(String variableName1, String variableName2) {
            super(variableName1, variableName2);
            this.operation = 2;
        }
    }

    private class VariableLessThanVariable
    extends VariableTestAgainstVariable {
        public VariableLessThanVariable(String variableName1, String variableName2) {
            super(variableName1, variableName2);
            this.operation = 1;
        }
    }

    private class VariableEqualityVariable
    extends VariableTestAgainstVariable {
        public VariableEqualityVariable(String variableName1, String variableName2) {
            super(variableName1, variableName2);
            this.operation = 0;
        }
    }

    private static abstract class VariableTestAgainstVariable
    implements Condition {
        private String variableName;
        private String variableName2;
        protected int operation;

        public VariableTestAgainstVariable(String variableName1, String variableName2) {
            this.variableName = variableName1;
            this.variableName2 = variableName2;
        }

        public boolean evaluate(ContextImpl context) throws StateTransitionSupportException {
            try {
                VariableImpl variable = VariableOperator.resolveVariable(this.variableName, context);
                VariableImpl variable2 = VariableOperator.resolveVariable(this.variableName2, context);
                boolean result = StateTransitionSupport.doTest(this.operation, variable.getValue(), variable.getType(), variable2.getValue(), variable2.getType());
                Trace.trace(StateTransitionSupport.TRACE_MASKD, this.toString() + "[result=" + result + "]");
                return result;
            }
            catch (UnresolvableValueException e) {
                Trace.trace(StateTransitionSupport.TRACE_MASKD, this.toString() + " UnresolvableValueException; return false");
                return false;
            }
        }

        public String toString() {
            return "VariableTestAgainstVariable[" + this.variableName + "][" + this.variableName2 + "]";
        }
    }

    private class VariableGreaterThanLiteral
    extends VariableTestAgainstLiteral {
        public VariableGreaterThanLiteral(String variableName, String literalValue) {
            super(variableName, literalValue);
            this.operation = 2;
        }
    }

    private class VariableLessThanLiteral
    extends VariableTestAgainstLiteral {
        public VariableLessThanLiteral(String variableName, String literalValue) {
            super(variableName, literalValue);
            this.operation = 1;
        }
    }

    private class VariableEqualityLiteral
    extends VariableTestAgainstLiteral {
        public VariableEqualityLiteral(String variableName, String literalValue) {
            super(variableName, literalValue);
            this.operation = 0;
        }
    }

    private static abstract class VariableTestAgainstLiteral
    implements Condition {
        private String variableName;
        private String literalValue;
        protected int operation;

        public VariableTestAgainstLiteral(String variableName, String literalValue) {
            this.variableName = variableName;
            this.literalValue = literalValue;
        }

        public boolean evaluate(ContextImpl context) throws StateTransitionSupportException {
            try {
                VariableImpl variable = VariableOperator.resolveVariable(this.variableName, context);
                String type = variable.getType();
                boolean result = StateTransitionSupport.doTest(this.operation, variable.getValue(), type, this.literalValue, type);
                Trace.trace(StateTransitionSupport.TRACE_MASKD, this.toString() + "[result=" + result + "]");
                return result;
            }
            catch (UnresolvableValueException e) {
                Trace.trace(StateTransitionSupport.TRACE_MASKD, this.toString() + " UnresolvableValueException; return false");
                return false;
            }
        }

        public String toString() {
            return "VariableTestAgainstLiteral[" + this.variableName + "][" + this.literalValue + "]";
        }
    }

    private static abstract class ParentCondition
    implements Condition {
        private LinkedList children = new LinkedList();

        private ParentCondition() {
        }

        public void addChild(Condition child) {
            this.children.addLast(child);
        }

        public List getChildren() {
            return this.children;
        }
    }

    private static interface Condition
    extends Serializable {
        public boolean evaluate(ContextImpl var1) throws StateTransitionSupportException;
    }
}

